unit UnDirectoryView;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  SBtn, ExtCtrls, ComCtrls, DirectoryView, StdCtrls, SEdit;

type
  TForm2 = class(TForm)
    DirectoryView1: TDirectoryView;
    Panel1: TPanel;
    Panel2: TPanel;
    SBtn1: TSBtn;
    EdtPath: TSEdit;
    EdtName: TSEdit;
    Label1: TLabel;
    EdtFName: TSEdit;
    Label2: TLabel;
    SBtn2: TSBtn;
    CbxCD: TCheckBox;
    CbxRem: TCheckBox;
    CbxNet: TCheckBox;
    procedure DirectoryView1Change(Sender: TObject; Node: TTreeNode);
	procedure DirectoryView1Find(Sender: TObject; Directory, FileName: String);
	procedure DirectoryView1Changing(Sender: TObject; Node: TTreeNode; var AllowChange: Boolean);
	procedure SBtn1Click(Sender: TObject);
	procedure FormCreate(Sender: TObject);
	procedure EdtNameModifyEx(Sender: TObject; var Accept: Boolean);
	procedure FormShow(Sender: TObject);
	procedure FormClose(Sender: TObject; var Action: TCloseAction);
	procedure CbxCDClick(Sender: TObject);
  private
	{ Private 錾 }
  public
	{ Public 錾 }
  end;

var
  Form2: TForm2;

implementation

uses UnGridTest;

{$R *.DFM}

procedure TForm2.FormCreate(Sender: TObject);
begin
	Constraints.MinWidth := Width;
	Constraints.MaxWidth := Width;
	Constraints.MinHeight := Height;
	Constraints.MaxHeight := Height;
end;

procedure TForm2.FormShow(Sender: TObject);
begin
	UnGridTest.ClearComponents(Self);
	with DirectoryView1 do begin
		if Active then Active := False;
		DriveType := [dtDRIVE_FIXED];
		if CbxCD.Checked then DriveType := DriveType + [dtDRIVE_CDROM];
		if CbxNet.Checked then DriveType := DriveType + [dtDRIVE_REMOTE];
		if CbxRem.Checked then DriveType := DriveType + [dtDRIVE_REMOVABLE];
		Active := True;
		SearchFile := ExtractFileName(Application.ExeName);
		EdtName.AsString := ExtractFileName(Application.ExeName);
	end;
end;

procedure TForm2.FormClose(Sender: TObject; var Action: TCloseAction);
begin
	DirectoryView1.Active := False;
end;

procedure TForm2.DirectoryView1Changing(Sender: TObject; Node: TTreeNode; var AllowChange: Boolean);
begin
	//Node.Text ݁ij̃pXłB
	with TDirectoryView(Sender) do begin
		EdtPath.Clear;
		EdtFName.Clear;
		EdtPath.Color := clWhite;
		EdtFName.Color := clWhite;
		SBtn1.Caption := '߂Ȃ';
		SBtn1.Guide := 'Not Found';
	end;
end;

procedure TForm2.DirectoryView1Change(Sender: TObject; Node: TTreeNode);
begin
	with TDirectoryView(Sender) do begin
		EdtPath.AsString := Directory;
	end;
end;

procedure TForm2.DirectoryView1Find(Sender: TObject; Directory, FileName: String);
begin
	EdtPath.Color := clAqua;
	EdtFName.Color := clAqua;
	EdtPath.AsString := Directory;
	EdtFName.AsString := FileName;
	SBtn1.Caption := '߂';
	SBtn1.Guide := 'Found !!';
end;

procedure TForm2.SBtn1Click(Sender: TObject);
begin
	if Pos('߂',TSBtn(Sender).Caption) > 0 then  begin
		Self.Close;
	end;
end;

procedure TForm2.EdtNameModifyEx(Sender: TObject; var Accept: Boolean);
begin
	With DirectoryView1, TSEdit(Sender) do begin
		SearchFile := Text;
	end;
end;

procedure TForm2.CbxCDClick(Sender: TObject);
begin
	with DirectoryView1 do begin
		if Active then Active := False;
		DriveType := [dtDRIVE_FIXED];
		if CbxCD.Checked then DriveType := DriveType + [dtDRIVE_CDROM];
		if CbxNet.Checked then DriveType := DriveType + [dtDRIVE_REMOTE];
		if CbxRem.Checked then DriveType := DriveType + [dtDRIVE_REMOVABLE];
		Active := True;
		SetFocus;
	end;
end;

end.
