//*********************************************************
//		^Cg:<dE֐vO>
//*********************************************************
//
//
//				by NGCeBu\tg
//
//				<2001.09>   <>
//
//*********************************************************

{C
	yyyy.mm.dd	who  ύXCe
   ~~~~~~~~~~  ~~~  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

}
unit UnCalc;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, SEdit, Buttons, CsTypeDef, SBtn, Grids;

type
  TFrmCalc = class(TForm)
		sb17: TSBtn;
		sb13: TSBtn;
		sb03: TSBtn;
		sb02: TSBtn;
		sb01: TSBtn;
		sb16: TSBtn;
		sb12: TSBtn;
		sb11: TSBtn;
		sb10: TSBtn;
		sb00: TSBtn;
		sb19: TSBtn;
		sb15: TSBtn;
		sb09: TSBtn;
		sb08: TSBtn;
		sb07: TSBtn;
		sb18: TSBtn;
		sb14: TSBtn;
		sb06: TSBtn;
		sb05: TSBtn;
		sb04: TSBtn;
		edtShow: TSEdit;
		Shape1: TShape;
		Shape2: TShape;
		sb21: TSBtn;
		sb20: TSBtn;
		Shape3: TShape;
		sh1: TShape;
		sh2: TShape;
		sh3: TShape;
		sh4: TShape;
		sh5: TShape;
		lb2: TLabel;
		lb3: TLabel;
		lb4: TLabel;
		lb5: TLabel;
		lbMsg: TLabel;
		Shape4: TShape;
		Shape5: TShape;
		Shape6: TShape;
		Shape7: TShape;
		Shape8: TShape;
		Shape9: TShape;
		Shape10: TShape;
		Shape11: TShape;
		Shape12: TShape;
		Shape13: TShape;
		Shape14: TShape;
		Shape15: TShape;
		Shape16: TShape;
		Shape17: TShape;
		Shape18: TShape;
		Shape19: TShape;
		Shape20: TShape;
		Shape21: TShape;
		Shape22: TShape;
		Shape23: TShape;
		Shape24: TShape;
		Shape25: TShape;
		Shape26: TShape;
		Shape27: TShape;
		sbC1: TSBtn;
		sbC2: TSBtn;
		lb1: TLabel;
		shMain: TShape;
		procedure sbNumClick(Sender: TObject);
		procedure FormShow(Sender: TObject);
		procedure edtShowKeyUp(Sender: TObject; var Key: Word; Shift: TShiftState);
		procedure edtShowKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
		procedure sbC1Click(Sender: TObject);
		procedure sbC2Click(Sender: TObject);
		procedure FormCreate(Sender: TObject);
	private
		{ Private 錾 }
		procedure ToggleShape(sh: TShape);
		procedure ClearShape;
		procedure calculate(value:string);
	public
		{ Public 錾 }
	end;

function Calculater(Sender: TObject; value:string):string;
procedure GridPos(Sender: TObject;Wind:TForm);


const
	ResultStr:string = '';
	Max:Extended = 999999999999.0;
	Min:Extended = -999999999999.0;
	Ureg:Extended = 0.0;
	Areg:Extended = 0.0;
	Initial:boolean = True;

var
	FrmCalc: TFrmCalc;

implementation


var
	en:	string;
	Progress:boolean;

{$R *.DFM}

function Calculater(Sender: TObject; value:string):string;
begin
	if FrmCalc = nil then Application.CreateForm(TFrmCalc,FrmCalc);
	ResultStr := value;
	GridPos(Sender,FrmCalc);
	FrmCalc.ShowModal;
	Result := ResultStr;
	FrmCalc.Free;
	FrmCalc := nil;
end;

//---------------------------------------------------------
//				̈ʒu
//---------------------------------------------------------
procedure GridPos(Sender: TObject;Wind:TForm);
var
	xy:TPoint;
	r:TRect;
	h,w:integer;
begin
	//̈ʒu

	if Sender = nil then exit;
	if not (Sender is TControl) then exit;
	if Wind = nil then exit;

	with Wind do begin
		if Sender is TDrawGrid then begin
			with TDrawGrid(Sender) do begin
				r := CellRect(Col,Row);
				xy.x := r.TopLeft.x;
				xy.y := r.BottomRight.y;
				xy   := TControl(Sender).ClientToScreen(xy);
				w := r.BottomRight.x - r.TopLeft.x;
				h := r.BottomRight.y - r.TopLeft.y;
			end;
		end else begin
			xy.x := 0;
			xy.y := TControl(Sender).Height;
			xy   := TControl(Sender).ClientToScreen(xy);
			w := TControl(Sender).Width;
			h := TControl(Sender).Height;
		end;

		if xy.y + Height > Screen.Height then begin		//Rg[̏ɏo
			Top  := xy.y - Height - h - 1;
		end else begin									//Rg[̉ɏo
			Top  := xy.y + 1;
		end;
		if xy.x + Width > Screen.Width then begin		//Rg[̍ɏo
			Left := xy.x + w - Width - 1;
		end else begin									//Rg[̉Eɏo
			Left := xy.x + 1;
		end;
		if Left < 0 then Left := 0;
		if Left + Width > Screen.Width then Left := Screen.Width - Width;
	end;
end;

procedure TFrmCalc.calculate(value:string);
begin
	if Trim(lbMsg.Caption) = '' then exit;
	if Trim(edtShow.Text)  = '' then exit;
	if Trim(en)            = '' then exit;
	try
		case en[1] of
			'+':begin
				if value = '%' then begin
					Areg := Ureg + Ureg * Areg * 0.01;
					edtShow.Text := FloatToStr(Areg);
					Ureg := 0.0;
				end else begin
					Areg := Ureg + Areg;
					edtShow.Text := FloatToStr(Areg);
					Ureg := 0.0;
				end;
			end;
			'-':begin
				if value = '%' then begin
					Areg := Ureg - Ureg * Areg * 0.01;
					edtShow.Text := FloatToStr(Areg);
					Ureg := 0.0;
				end else begin
					Areg := Ureg - Areg;
					edtShow.Text := FloatToStr(Areg);
					Ureg := 0.0;
				end;
			end;
			'*':begin
				if value = '%' then begin
					Areg := Ureg * Areg * 0.01;
					edtShow.Text := FloatToStr(Areg);
					Ureg := 0.0;
				end else begin
					Areg := Ureg * Areg;
					edtShow.Text := FloatToStr(Areg);
					Ureg := 0.0;
				end;
			end;
			'/':begin
				if value = '%' then begin
					lbMsg.Caption := '̓G[';
					exit;
				end;
				if edtShow.AsFloat = 0 then begin
					lbMsg.Caption := 'ꂪ[ł';
					exit;
				end;
				Areg := Ureg / Areg;
				edtShow.Text := FloatToStr(Areg);
				Ureg := 0.0;
			end;
		end;
		edtShow.Update;
		ClearShape;
	except
		lbMsg.Caption := 'G[';
		ClearShape;
		en := '';
		lbMsg.Caption := '';
		Progress:=False;
	end;
	ClearShape;
	en := '';
	Ureg:= 0.0;
	Progress:=False;
	case edtShow.ErrorType of
		erMinValue:lbMsg.Caption := 'ʂ܂';
		erMaxValue:lbMsg.Caption := 'ʂ傫܂';
		else lbMsg.Caption := '';
	end;
end;

procedure TFrmCalc.ClearShape;
var
	i:integer;
	sh:TShape;
begin
	for i := 1 to 4 do begin
		sh := TShape(FindComponent('sh'+InttoStr(i)));
		sh.Brush.Style := bsSolid;
		sh.Brush.Color := Shape3.Brush.Color;
		sh.Pen.Color   := clWhite;
	end;
end;

procedure TFrmCalc.ToggleShape(sh: TShape);
begin
	if sh.Pen.Color = clBlack then begin
		sh.Brush.Style := bsSolid;
		sh.Brush.Color := Shape3.Brush.Color;
		sh.Pen.Color   := clWhite;
		Progress := False;
	end else begin
		sh.Brush.Style := bsClear;
		sh.Pen.Color   := clBlack;
		Progress := True;
		case sh.name[3] of
			'1':en := '+';
			'2':en := '-';
			'3':en := '*';
			'4':en := '/';
			else en := 'Invalid';
		end;
	end;
end;

procedure TFrmCalc.FormShow(Sender: TObject);
begin
//	Top  := Round(Screen.Height * 0.3);
//	Left := Round(Screen.Width  * 0.6);
	ClearShape;
	Ureg:= 0.0;
	edtShow.FpLength := 2;
	edtShow.MaxValue := Trunc(Max);
	edtShow.MinValue := Trunc(Min);
	edtShow.CharTypes := edtShow.CharTypes + [ctConmma,ctPeriod,ctMinus];
	edtShow.Text := ResultStr;
	try
		Areg := edtShow.AsFloat;
	except
		edtShow.Text := '';
		Areg := 0.0;
		Initial:= True;
		Progress:=False;
		edtShow.SetFocus;
		exit;
	end;
	lbMsg.Caption := '';
	edtShow.SelStart := Length(edtShow.Text);
	edtShow.SetFocus;
	Initial:= False;
	Progress:=True;
end;

procedure TFrmCalc.FormCreate(Sender: TObject);
var
	i:integer;
	sh:TShape;
	lb:TLabel;
	r:TRect;
begin
	shMain.SetBounds(0,0,ClientWidth,ClientHeight);
	ClearShape;
	Ureg:= 0.0;
	Areg:= 0.0;
	edtShow.FpLength := 2;
	edtShow.MaxValue := Trunc(Max);
	edtShow.MinValue := Trunc(Min);
	edtShow.CharTypes := edtShow.CharTypes + [ctConmma,ctPeriod,ctMinus];
	edtShow.Text := ResultStr;
	lbMsg.Caption := '';

	i := 1;
	sh := TShape(FindComponent(Format('sh%d',[i])));
	while sh <> nil do begin
		lb := TLabel(FindComponent(Format('lb%d',[i])));
		if lb = nil then break;
		r := sh.BoundsRect;
    r.Left := r.Left + 1;
		lb.BoundsRect := r;
    lb.Transparent := True;
		sh.BringToFront;
		inc(i);
		sh := TShape(FindComponent(Format('sh%d',[i])));
	end;

	edtShow.SelStart := Length(edtShow.Text);
	Initial:= True;
	Progress:=False;
end;

procedure TFrmCalc.sbNumClick(Sender: TObject);
var
	f:Extended;
	i,j:integer;
	sh:TShape;
begin
	i := strToInt(copy(TSBtn(Sender).name,3,2));
	case i of
		0..9:begin
			with edtShow do begin
				if Initial then begin
					lbMsg.Caption :=  '';
					Text := '';
					ClearShape;
					Initial := False;
				end else if Progress then begin
					lbMsg.Caption := Text;
					Ureg := Areg;
					Text := '';
					Progress := False;
				end;
				if (Pos('.',Text) > 0) and (Length(Text) - Pos('.',Text) >= FpLength) then exit;
				Text := Text + IntToStr(i);
				try
					f := AsFloat;
					Areg := f;
					Text := FloatToStr(f);
				except
					Text := '0';
					Areg := 0.0;
				end;
			end;
		end;
		10:begin					// +/-
			try
				f := edtShow.AsFloat;
				Areg := f;
				edtShow.AsFloat := -f;
			except
			end;
		end;
		11:begin					// .
			if Initial then begin
				lbMsg.Caption :=  '';
				edtShow.Text := '';
				ClearShape;
				Initial := False;
			end else if Progress then begin
				lbMsg.Caption := edtShow.Text;
				Ureg := Areg;
				edtShow.Text := '';
				Progress := False;
			end;
			if Pos('.',edtShow.Text) > 0 then exit;
			edtShow.Text := edtShow.Text + '.';
		end;
		12..15:begin				// + ` /
			if (Trim(edtShow.Text) = '') and (lbMsg.Caption = '') then exit;
			j := i - 11;
			{try
				f := edtShow.AsFloat;
			except
				case j of
					1:en := '+';
					2:en := '-';
					3:en := '*';
					4:en := '/';
				end;
				sh := TShape(FindComponent('sh'+IntToStr(j)));
				if sh.Pen.Color = clWhite then ClearShape;
				ToggleShape(sh);
				exit;
			end;}
			Calculate('');
			case j of
				1:en := '+';
				2:en := '-';
				3:en := '*';
				4:en := '/';
			end;
			sh := TShape(FindComponent('sh'+IntToStr(j)));
			ToggleShape(sh);
			if sh.Pen.Color = clWhite then ClearShape;
		end;
		16:calculate('');			// =
		17:calculate('%');			// %
		18:begin					// bs
			if Length(edtShow.Text) < 2 then begin
				edtShow.Text := '';
				exit;
			end;
			edtShow.Text := Copy(edtShow.Text,1,Length(edtShow.Text) - 1);
		end;
		19:begin					// clr
			ClearShape;
			en := '';
			edtShow.Text := '';
			lbMsg.Caption := '';
			Ureg:= 0.0;
			Areg:= 0.0;
			Progress:=False;
			Initial:= True;
		end;
		20:begin					// cancel
			ResultStr := '';
			Close;
		end;
		21:begin					// return
			edtShow.Update;
			ResultStr := edtShow.Text;
			Close;
		end;
	end;
	edtShow.SelStart := Length(edtShow.Text);
end;

procedure TFrmCalc.edtShowKeyUp(Sender: TObject; var Key: Word; Shift: TShiftState);
var
	f:Extended;
begin
	case Key of
		35:begin
			calculate('%');
		end;
		13:begin						// cr
			edtShow.Update;
			ResultStr := edtShow.Text;
			Close;
		end;
		27:begin						// esc
			ResultStr := '';
			Close;
		end;
		146,189:begin					// =(146 : NEC PC-98)
			calculate('');
		end;
		108,53:begin					// %,','
			calculate('%');
		end;
		36:begin						// home'
			ClearShape;
			en := '';
			edtShow.Text := '';
			lbMsg.Caption := '';
			Ureg:= 0.0;
			Areg:= 0.0;
			Progress:=False;
			Initial:= True;
		end;
		96..105:begin					// 0 ` 9
			if Progress then exit;
			with TSEdit(Sender) do begin
				try
					f := AsFloat;
					Areg := f;
					if Pos('.',edtShow.Text) = 0 then begin
						Text := FloatToStr(f);
					end else begin
						if Length(edtShow.Text) - Pos('.',edtShow.Text) >
							edtShow.FpLength then begin
								edtShow.Text :=
									Copy(edtShow.Text,1,Length(edtShow.Text) - 1);
						end;
					end;
				except
					Text := '0';
					Areg := 0.0;
				end;
			end;
		end;
		{
		110:begin					// .
			if Progress then exit;
			TSEdit(Sender).Text := TSEdit(Sender).Text;
		end;
		}
	end;
	edtShow.SelStart := Length(edtShow.Text);
end;

{$WARNINGS OFF}
procedure TFrmCalc.edtShowKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
var
	i:integer;
	sh:TShape;
begin
	case key of
		106,107,109,111:begin				// + ` /
			if Trim(edtShow.Text) = '' then begin
				key := 0;
				exit;
			end;
			{try
				f := edtShow.AsFloat;
			except
				case Key of
					107:begin
						en := '+';
						i := 1;					// +
					end;
					109:begin
						en := '-';
						i := 2;         // -
					end;
					106:begin
						en := '*';
						i := 3;         // *
					end;
					111:begin
						en := '/';
						i := 4;
					end;
				end;
				sh := TShape(FindComponent('sh'+InttoStr(i)));
				if sh.Pen.Color = clWhite then ClearShape;
				ToggleShape(sh);
				exit;
			end;}
			Calculate('');
			case Key of
				107:begin
					en := '+';
					i := 1;					// +
				end;
				109:begin
					en := '-';
					i := 2;         // -
				end;
				106:begin
					en := '*';
					i := 3;         // *
				end;
				111:begin
					en := '/';
					i := 4;
				end;
			end;
			sh := TShape(FindComponent('sh'+InttoStr(i)));
			ToggleShape(sh);
			if sh.Pen.Color = clWhite then ClearShape;
		end;
		96..105,110:begin					// 0 ` 9
			if Initial then begin
				lbMsg.Caption :=  '';
				edtShow.Text := '';
				ClearShape;
				Initial := False;
			end else if Progress then begin
				lbMsg.Caption := TSEdit(Sender).Text;
				Ureg := Areg;
				TSEdit(Sender).Text := '';
				Progress := False;
			end;
		end;
	end;
end;
{$WARNINGS ON}

procedure TFrmCalc.sbC1Click(Sender: TObject);
var
	i:integer;
begin
	i := edtShow.FpLength;
	if i < 5 then begin
		edtShow.FpLength := i + 1;
		sbC1.Caption := Format('%.'+ IntToStr(i + 1) + 'f ',[0.0]);
		sbC2.Caption := Format('%.'+ IntToStr(i + 1) + 'f ',[0.0]);
		edtShow.MaxValue := Trunc(Max);
		edtShow.MinValue := Trunc(Min);
		edtShow.CharTypes := edtShow.CharTypes + [ctConmma,ctPeriod,ctMinus];
		edtShow.Text := FloatToStr(Areg);
		edtShow.Update;
	end;
end;

procedure TFrmCalc.sbC2Click(Sender: TObject);
var
	i:integer;
begin
	i := edtShow.FpLength;
	if i > 0 then begin
		edtShow.FpLength := i - 1;
		sbC1.Caption := Format('%.'+ IntToStr(i - 1) + 'f ',[0.0]);
		sbC2.Caption := Format('%.'+ IntToStr(i - 1) + 'f ',[0.0]);
		edtShow.MaxValue := Trunc(Max);
		edtShow.MinValue := Trunc(Min);
		edtShow.CharTypes := edtShow.CharTypes + [ctConmma,ctPeriod,ctMinus];
		edtShow.Text := FloatToStr(Areg);
		edtShow.Update;
	end;
end;

end.
