unit UnBarCode;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls, SEdit, CBarCode, SBtn, CsStdCtrls;

type
  TForm6 = class(TForm)
    TexturePanel1: TTexturePanel;
    Panel1: TPanel;
    TextureLabel1: TTextureLabel;
    Panel2: TPanel;
    Panel3: TPanel;
    CBarImage1: TCBarImage;
    CQRImage1: TCQRImage;
    Panel4: TPanel;
    Panel5: TPanel;
    SEdit1: TSEdit;
    Label1: TLabel;
    Panel6: TPanel;
    SEdit2: TSEdit;
    Label2: TLabel;
    Panel7: TPanel;
    Label3: TLabel;
    Label4: TLabel;
    Panel8: TPanel;
    Panel9: TPanel;
    ScbBarType: TSComboBox;
    ScbCellSize: TSComboBox;
    Shape1: TShape;
    Label5: TLabel;
    Panel10: TPanel;
    ScbAngle: TSComboBox;
    SBtn1: TSBtn;
    Image1: TImage;
    Label6: TLabel;
    Label7: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure SBtn1Click(Sender: TObject);
    procedure ScbBarTypeModifyEx(Sender: TObject; var Accept: Boolean);
  private
    { Private 錾 }
  public
    { Public 錾 }
  end;

var
  Form6: TForm6;

implementation

uses UnGridTest;

{$R *.dfm}

var
	sbt:array[0..11] of string =
		('btJAN', 'btUPC', 'btCODE39', 'btNW7', 'btITF', 'btCTF','btIATA',
		 'btMATRIX', 'btNEC', 'btCUSTOMER', 'btCODE128', 'btCODE93');

procedure TForm6.FormCreate(Sender: TObject);
var
	i:integer;
begin
	UnGridTest.ClearComponents(Self);
	ScbBarType.Items.Clear;
	for i := 0 to Length(sbt) - 1 do begin
		ScbBarType.Items.Add(sbt[i]);
	end;
	ScbBarType.ItemIndex := ScbBarType.Items.IndexOf('btNW7');
	SEdit1.AsString := CBarImage1.Caption;
	SEdit2.AsString := CQRImage1.Caption;
	ScbAngle.ItemIndex := ScbAngle.Items.IndexOf(IntToStr(CBarImage1.Angle));
	ScbCellSize.ItemIndex := ScbCellSize.Items.IndexOf(IntToStr(CQRImage1.CellSize));
end;

procedure TForm6.FormShow(Sender: TObject);
var
	str:TStringList;
begin
	Panel7.ClientHeight := ScbBarType.RequiredHeight;
	Panel4.ClientHeight := SEdit1.RequiredHeight;

	str := TStringList.Create;
	try
		str.Add(Panel1.Name);
		SetMvChains(str,Self);
		Image1.Picture.Assign(CBarImage1.Picture);
	finally
		str.Free;
  end;
end;

procedure TForm6.SBtn1Click(Sender: TObject);
begin
	Self.Close;
end;

procedure TForm6.ScbBarTypeModifyEx(Sender: TObject; var Accept: Boolean);
begin
	if					Sender is TSEdit then begin
		with TSEdit(Sender) do begin
			if					Sender = SEdit1 then begin
				CBarImage1.Caption := AsString;
				Image1.Picture.Assign(CBarImage1.Picture);
			end else if Sender = SEdit2 then begin
				CQRImage1.Caption := AsString;
			end;
		end;
	end else if Sender is TSComboBox then begin
		with TSComboBox(Sender) do begin
			if					Sender = ScbBarType then begin
				CBarImage1.BarType := TBarType(ItemIndex);
				if CBarImage1.BarType <> btCUSTOMER then CBarImage1.BarHeight := 75;
				Image1.Picture.Assign(CBarImage1.Picture);
			end else if Sender = ScbAngle then begin
				CBarImage1.Angle := StrToIntDef(Text,0);
				Image1.Picture.Assign(CBarImage1.Picture);
			end else if Sender = ScbCellSize then begin
      	CQRImage1.CellSize := StrToIntDef(Text,1);
			end;
		end;
	end;
end;

end.
